CREATE DATABASE IF NOT EXISTS capacity;
use capacity;
DROP TABLE IF EXISTS `r_work`;
CREATE TABLE `r_work` (
  `guid` VARCHAR(255) NOT NULL,
  `name` VARCHAR(255) NOT NULL DEFAULT '',
  `workspace` VARCHAR(50) NOT NULL DEFAULT '',
  `output` VARCHAR(2000) NOT NULL DEFAULT '',
  `expr` VARCHAR(255) NOT NULL DEFAULT '',
  `func_x` VARCHAR(255) NOT NULL DEFAULT '',
  `func_x_name` VARCHAR(500) NOT NULL DEFAULT '',
  `func_b` VARCHAR(255) NOT NULL DEFAULT '',
  `level` INT NOT NULL DEFAULT 0,
  `legend_x` VARCHAR(500) NOT NULL DEFAULT '',
  `legend_y` VARCHAR(100) NOT NULL DEFAULT '',
  `update_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`guid`)
) ENGINE=INNODB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `r_images`;
CREATE TABLE `r_images` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `guid` VARCHAR(255) NOT NULL,
  `workspace` VARCHAR(50) NOT NULL DEFAULT '',
  `data` BLOB,
  `update_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=INNODB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `r_chart`;
CREATE TABLE `r_chart` (
  `guid` VARCHAR(255) NOT NULL,
  `y_real` TEXT,
  `y_func` TEXT,
  `update_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`guid`)
) ENGINE=INNODB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `r_monitor`;
CREATE TABLE `r_monitor` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `guid` VARCHAR(255) NOT NULL,
  `endpoint` VARCHAR(100) NOT NULL DEFAULT '',
  `metric` VARCHAR(100) NOT NULL DEFAULT '',
  `agg` VARCHAR(10) NOT NULL DEFAULT 'none',
  `start` VARCHAR(50) NOT NULL DEFAULT '',
  `end` VARCHAR(50) NOT NULL DEFAULT '',
  `update_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=INNODB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;