#!/usr/bin/env sh

set -e

BASE_DIR="$(dirname "$0")/.."
LIB_DIR="$BASE_DIR/lib"
LOGS_DIR="$BASE_DIR/logs"

SERVER_PORT=${SERVER_PORT:-[@server_port]}
JMX_HOSTNAME=${JMX_HOSTNAME:-[@jmx_hostname]}
JMX_PORT=${JMX_PORT:-[@jmx_port]}

nohup java \
  -Djava.rmi.server.hostname="$JMX_HOSTNAME" -Dcom.sun.management.jmxremote.port="$JMX_PORT" \
  -Dcom.sun.management.jmxremote.ssl=false -Dcom.sun.management.jmxremote.authenticate=false \
  -jar "$LIB_DIR/bootcamp-app-java-spring-boot.jar" \
  --server.port="$SERVER_PORT" \
  >"$LOGS_DIR/out.log" 2>&1 &

echo "Started service in background."

HEALTH_CHECK_URL="http://127.0.0.1:$SERVER_PORT"
MAX_ATTEMPTS=6
SLEEP_TIME=10

echo "Performing health check against: $HEALTH_CHECK_URL"
for i in $(seq 1 $MAX_ATTEMPTS); do
  echo "[Attempt $i/$MAX_ATTEMPTS]"
  if $(curl -fsS $HEALTH_CHECK_URL >/dev/null); then
    echo "Service is UP."
    exit 0
  elif [ $i -lt $MAX_ATTEMPTS ]; then
    echo "Service is not up yet, retry in $SLEEP_TIME seconds..."
    sleep $SLEEP_TIME
  else
    echo "Service is still DOWN!"
    exit 1
  fi
done
