#!/usr/bin/env sh

set -e

SCRIPT_DIR=$(dirname "$0")
VERSION_DIR=$(realpath "$SCRIPT_DIR/..")
APP_DIR=$(realpath "$VERSION_DIR/..")
CURRENT_SYM_LINK="$APP_DIR/current"
PREVIOUS_SYM_LINK="$APP_DIR/previous"

echo "Stopping service from previously deployed version..."
$SCRIPT_DIR/stop-current.sh

echo "Switching current version to $VERSION_DIR..."
[ -L "$PREVIOUS_SYM_LINK" ] && rm -f "$PREVIOUS_SYM_LINK"
[ -L "$CURRENT_SYM_LINK" ] && mv $CURRENT_SYM_LINK $PREVIOUS_SYM_LINK
ln -s "$VERSION_DIR" "$CURRENT_SYM_LINK"

echo "Starting service of new version..."
$SCRIPT_DIR/start-current.sh

echo "Successfully completed deployment in $VERSION_DIR"
